using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class GeometryModule:ShaderGenerationModule
  { 
    [Export]
    public GeometryModifier[] modifiers = [];

    public override List<ShaderVariant> GetVariants( ShaderGenerationContext context )
    {
      var list = new List<ShaderCode>();

      var allModifiers = Lists.From( modifiers ).FilterNulls();
      
      allModifiers.ForEach(
        ( m )=>
        {
          var offsetIndex = allModifiers.Filter( l => l.IsSameType( m ) ).IndexOf( m );
          m.uniformGroup = "Geometry";
          var geometryCode = m.GetGeometryCode( context, offsetIndex );
          
          if ( geometryCode == null )
          {
            return;
          }

          list.AddRange( geometryCode );
        }
      );

      return ToVariants( list );
    }
  }
}