using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class GeometryTerrainOffset:GeometryModifier
  {   
    public override List<ShaderCode> GetGeometryCode( ShaderGenerationContext context, int offsetIndex )
    {
      if ( offsetIndex != 0 )
      {
        throw new System.Exception( "Unique component, can't be used multiple times");
      }

      if ( ShaderPhase.Includes == context.phase )
      { 
        return IncludeFromLibrary( "Terrain" );
      }

      if ( ShaderPhase.Variables == context.phase )
      {        
        return AsUniformGroup( "Terrain",
          
        @"
        uniform sampler2D terrainHeightMap;
        uniform vec2 terrainCenterXZ = vec2( 0.0, 0.0 );
        uniform vec2 terrainSizeXZ = vec2( 100.0, 100.0 );
        uniform float terrainMinHeight = 0.0;
        uniform float terrainMaxHeight = 100.0;
        "
          
        );
           
      }

      if ( ShaderPhase.Vertex == context.phase )
      {

        return ToInnerBlock( "Terrain",
          
        @" 
        addTerrainOffset( 
          MODEL_MATRIX, 
          VERTEX, 
          terrainHeightMap,
          terrainCenterXZ,
          terrainSizeXZ,
          terrainMinHeight,
          terrainMaxHeight
        );
        
        "
                  
        );
      }

      return null;
    }
  }
}