using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class ConstantMask:SpatialMask
  {         
    [Export]
    public float constantValue = 0.5f;
    
    public override List<ShaderCode> GetMaskCode( ShaderGenerationContext context, string contextName, string maskName )
    {
      if ( context.isFragmentPhase )
      {
        var code = $"{maskName} = {constantValue};\n";
        return ToCode( code.Indent( "    " ) );
      }

      return null;
    }
   
  }
}