using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class FresnelMask:SpatialMask
  {     
    [Export]
    public string name = "FresnelMask";   

    
    public override List<ShaderCode> GetMaskCode( ShaderGenerationContext context, string contextName, string maskName )
    {
      var prefix = contextName + name;
      var uniformGroup = contextName + "FresnelMask";

      if ( ShaderPhase.Includes == context.phase )
      {
        return IncludeLightLibrary();
      }
      else if ( ShaderPhase.Variables == context.phase )
      {
        var fresnelVariablesCode =

        $@"
        uniform float {prefix}FresnelZOffset = 0.0f;
        uniform float {prefix}FresnelPower = 1.0f;
        uniform float {prefix}FresnelPostScale = 1.0f;
        uniform float {prefix}FresnelPostOffset = 0.0f;
        uniform bool {prefix}FresnelInverse = false;

        ";

        return AsUniformGroup( uniformGroup, ToCode( fresnelVariablesCode.Indent( "" ) ) );
      }
      else if ( context.isFragmentPhase )
      {
        var code = 
        @$"
        
        {maskName} = clamp01( fresnelNormalizedFromViewAdvanced(  
          NORMAL,
          {prefix}FresnelZOffset,
          {prefix}FresnelPower,
          {prefix}FresnelPostScale, 
          {prefix}FresnelPostOffset 
        ) );
        
        if ( ! {prefix}FresnelInverse )
        {{ {maskName} = 1.0 - {maskName}; }}      


        ;";
        return ToCode( code.Indent( "    " ) );
      }

      return null;
    }
   
  }
}