using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class MaskReference:SpatialMask
  { 
    [Export]
    public string maskReference;

    public override List<ShaderCode> GetMaskCode( ShaderGenerationContext context, string contextName, string maskName )
    {
      if ( context.isFragmentPhase )
      {
        var code = $"{maskName} = {maskReference};\n";
        return ToCode( code.Indent( "    " ) );
      }

      return null;
    }
  }
}