using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class SpatialMaskVariable:ShaderGenerationModule
  { 
    [Export]
    public string maskName = "mask";

    [Export]
    public SpatialMaskFormulaType maskFormulaType = SpatialMaskFormulaType.Multiply;

    [Export]
    public string customMaskFormula;

    [Export]
    public SpatialMask[] masks = [];


    public List<ShaderCode> GetShaderCode( ShaderGenerationContext context )
    {
      var contextName = maskName;

      if ( context.isFragmentPhase )
      {
        var maskCode = SpatialMaskFormulaTypeUtility.GetFragmentMaskCode( 
          context, maskFormulaType, customMaskFormula, masks, contextName, maskName );

        return maskCode;
      }

      var list = new List<ShaderCode>();

      masks.ForEach(
        ( m )=>
        {
          var c = m.GetMaskCode( context, maskName, maskName );

          if ( c == null )
          {
            return;
          }

          list.Add( c );
        }
      );


      return list;
    }


  }
}