using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Linq;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class SpatialMasksModule:ShaderGenerationModule
  {  
    [Export]
    public SpatialMaskVariable[] maskVariables = [];
  
    public override List<ShaderVariant> GetVariants( ShaderGenerationContext context )
    {
      if ( maskVariables == null )
      {
        return null;
      }

      var variables = maskVariables.ToList().FilterNulls();

      if ( variables.Count == 0 )
      {
        return null;
      }

      var list = new List<ShaderCode>();

      variables.ForEach(
        ( v )=>
        {
          var code = v.GetShaderCode( context );

          if ( code == null )
          {
            return;
          } 

          list.Add( code );
        }
      );

      if ( context.isVariablesPhase )
      {
        list = AsUniformGroup( "Masks", list );
      }

      return ToVariants( list );
    }
  }
}