using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class ValueMask:SpatialMask
  {     
    [Export]
    public string name = "ValueMask";
    
    [Export]
    public float defaultValue = 0.5f;

    [Export]
    public float min = 0f;

    [Export]
    public float max = 1f;

    
    public override List<ShaderCode> GetMaskCode( ShaderGenerationContext context, string contextName, string maskName )
    {
      if ( ShaderPhase.Variables == context.phase )
      {
        var uniformGroupName = contextName + "." + name; 

        return AsUniformGroup( uniformGroupName, Uniform( contextName + name, defaultValue, min, max ) ) ; 
      }

      if ( context.isFragmentPhase )
      {
        var code = $"{maskName} = {contextName + name};\n";
        return ToCode( code.Indent( "    " ) );
      }

      return null;
    }
   
  }
}