using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class VaryingMask:SpatialMask
  {   
    [Export]
    public string varyingName;

    [Export]
    public ColorChannelType colorChannelType;
    
    public override List<ShaderCode> GetMaskCode( ShaderGenerationContext context, string contextName, string maskName )
    { 
      if ( context.isIncludesPhase )
      {
        if ( ColorChannelTypeUtility.NeedsIncludesForGLSLMember( colorChannelType ) )
        {
          return IncludeColorsLibrary();
        }
      }

      if ( context.isFragmentPhase )
      {
        var colorChannelValue = ColorChannelTypeUtility.ToGLSLMember( varyingName, colorChannelType );

        return ToCode( $"{maskName} = {colorChannelValue};" );
      }

      return null;
    }
   
  }
}