using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class MetallicModule:TextureModule
  { 
    public MetallicModule()
    {
      _domainName = "metallic";
      _domainScaleName = "metallic";
      _domainOffsetName = "metallicOffset";
      _domainValueName = "metallic";

      _target = "METALLIC";
      _type = TextureChannelType.ONE;
      _channelSource = TextureChannelSource.B;
      domainScaleDefault = 0;
    }

    [Export]
    public TextureFilter filter = TextureFilter.Linear_MipMap_Anisotropic;

    [Export]
    public DomainMode domainMode = DomainMode.Texture_Scale_Offset;

    [Export]
    public bool repeat = true;

    [Export]
    public string uvChannel = "UV";

    [Export]
    public TextureDefault textureDefault = TextureDefault.White;

    [Export]
    public AssignmentType assignmentType = AssignmentType.Set;   
    
    public override void GrabValues()
    {
      _domainMode = domainMode;
      _textureFilter = filter;
      _repeat = repeat;
      _textureDefault = textureDefault;
      _uvChannel = uvChannel;
      
      _assignmentType = assignmentType;
    }
  }
}