using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class NormalMapModule:TextureModule
  { 
    public NormalMapModule() 
    {
      _type = TextureChannelType.RGB;

      _domainName = "normal";
      _domainScaleName = "normalStrength";
      _domainValueName = "normal";
      _target = "NORMAL_MAP";
      _scaleTarget = "NORMAL_MAP_DEPTH";
      _normal = true;
      _type = TextureChannelType.RGB;
      scaleType = TextureChannelType.SCALAR;
    }

    [Export]
    public TextureFilter filter = TextureFilter.Linear_MipMap_Anisotropic;

    [Export]
    public bool useStrength = true;

    [Export]
    public float maximumStrength = 5;

    [Export]
    public bool allowNegativeStrength = false;

    [Export]
    public bool repeat = true;

    [Export]
    public string uvChannel = "UV";

    [Export]
    public TextureDefault textureDefault = TextureDefault.White;
    
    public override void GrabValues()
    {
      _domainMode = useStrength ? DomainMode.Texture_Scale : DomainMode.Texture;
      _textureFilter = filter;
      _repeat = repeat;
      _textureDefault = textureDefault;
      _uvChannel = uvChannel;

      domainScaleMax = Mathf.Abs( maximumStrength );
      domainScaleMin = allowNegativeStrength ? -Mathf.Abs( maximumStrength ) : 0;
    }
  }
}