using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class OcclusionModule:TextureModule
  { 
    public OcclusionModule()
    {
      _domainName = "occlusion";
      _domainScaleName = "occlusion";
      _domainOffsetName = "occlusionOffset";
      _domainValueName = "occlusion";
      
      _target = "AO";
      _type = TextureChannelType.ONE;
      _channelSource = TextureChannelSource.R;

    }

    [Export]
    public TextureFilter filter = TextureFilter.Linear_MipMap_Anisotropic;

    [Export]
    public DomainMode domainMode = DomainMode.Texture_Scale_Offset;

    [Export]
    public bool repeat = true;

    [Export]
    public string uvChannel = "UV";

    [Export]
    public TextureDefault textureDefault = TextureDefault.White;

    [Export]
    public AssignmentType assignmentType = AssignmentType.Set;   
    
    public override void GrabValues()
    {
      _domainMode = domainMode;
      _textureFilter = filter;
      _repeat = repeat;
      _textureDefault = textureDefault;
      _uvChannel = uvChannel;
      _assignmentType = assignmentType;
      
    }
  }
}