using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class RoughnessModule:TextureModule
  { 
    public RoughnessModule()
    {
      _domainName = "roughness";
      _domainScaleName = "roughness";
      _domainOffsetName = "roughnessOffset";
      _domainValueName = "roughness";

      _target = "ROUGHNESS";
      _type = TextureChannelType.ONE;
      _channelSource = TextureChannelSource.G;

    }

    [Export]
    public TextureFilter filter = TextureFilter.Linear_MipMap_Anisotropic;

    [Export]
    public DomainMode domainMode = DomainMode.Texture_Scale_Offset;

    [Export]
    public bool repeat = true;

    [Export]
    public string uvChannel = "UV";

    [Export]
    public TextureDefault textureDefault = TextureDefault.White;

    [Export]
    public AssignmentType assignmentType = AssignmentType.Set;   

    [Export]
    public bool clamp = true;
    
    public override void GrabValues()
    {
      _domainMode = domainMode;
      _textureFilter = filter;
      _repeat = repeat;
      _textureDefault = textureDefault;
      _uvChannel = uvChannel;
      _assignmentType = assignmentType;
      _clamp = clamp;
      
    }
  }
}