using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class SpatialShaderData:Resource
  { 
    [ExportGroup("Presets/Starters")]

    [ExportToolButton("PBR Starter")]
    public Callable pbrStarterButton => Callable.From(  ()=>{ PBR_Starter(); }  );

    [ExportToolButton("PBR Alpha Starter")]
    public Callable pbrAlphaStarterButton => Callable.From(  ()=>{ PBR_Alpha_Starter(); }  );

    [ExportToolButton("PBR Emissive Starter")]
    public Callable pbrEmissiveStarterButton => Callable.From(  ()=>{ PBR_Emissive_Starter(); }  );

    [ExportToolButton("PBR Luminance Starter")]
    public Callable pbrLuminanceStarterButton => Callable.From(  ()=>{ PBR_Luminance_Starter(); }  );

    [ExportToolButton("PBR All Starter")]
    public Callable pbrAllStarterButton => Callable.From(  ()=>{ PBR_All_Starter(); }  );

    [ExportToolButton("Unshaded Starter")]
    public Callable unshadedStarterButton => Callable.From(  ()=>{ Unshaded_Starter(); }  );



    [ExportGroup("Modules")]
    [Export]
    public TransparencyModule transparency = new TransparencyModule();

    [Export]
    public ShadingModule shading = new ShadingModule();

    [Export]
    public StencilModule stencil = null;

    [Export]
    public UVModule uv = new UVModule();

    [Export]
    public GeometryModule geometry = new GeometryModule();

    [Export]
    public SpatialVarying varying = new SpatialVarying();

    [Export]
    public SpatialMasksModule masks = new SpatialMasksModule();

    [Export]
    public AlbedoModule albedo = new AlbedoModule();

    [Export]
    public AlphaModule alpha = null;

    [Export]
    public FadingModule fading = null;


    [Export]
    public NormalMapModule normalMap = null;

    [Export]
    public RoughnessModule roughness = null;

    [Export]
    public MetallicModule metallic = null;

    [Export]
    public SpecularModule specular = null;


    [Export]
    public OcclusionModule occlusion = null;

    [Export]
    public EmissionModule emission = null;

    [Export]
    public BacklightModule backlight = null;

    [Export]
    public SubsurfaceScatteringModule subsurfaceScattering = null;

    [Export]
    public SpatialOverlayLayer[] layers;

    public void PBR_All_Starter()
    {
      transparency = new TransparencyModule();
      shading = new ShadingModule();
      stencil = null;

      geometry = new GeometryModule();

      uv = new UVModule();

      albedo = new AlbedoModule();
      alpha = null;
      fading = null;

      normalMap = new NormalMapModule();
      roughness = new RoughnessModule();
      metallic = new MetallicModule();
      specular = new SpecularModule();
      specular.domainMode = TextureModule.DomainMode.Value;
      occlusion = new OcclusionModule();

      emission = new EmissionModule();
      backlight = new BacklightModule();
      subsurfaceScattering = new SubsurfaceScatteringModule();
    }

    public void PBR_Luminance_Starter()
    {
      transparency = new TransparencyModule();
      shading = new ShadingModule();
      stencil = null;

      geometry = new GeometryModule();

      uv = new UVModule();

      albedo = new AlbedoModule();
      alpha = null;
      fading = null;

      normalMap = new NormalMapModule();
      roughness = new RoughnessModule();
      metallic = new MetallicModule();
      specular = new SpecularModule();
      specular.domainMode = TextureModule.DomainMode.Value;
      occlusion = new OcclusionModule();

      emission = null;
      backlight = new BacklightModule();
      subsurfaceScattering = new SubsurfaceScatteringModule();
    }

    

    public void PBR_Starter()
    {
      transparency = new TransparencyModule();
      shading = new ShadingModule();
      stencil = null;

      geometry = new GeometryModule();

      uv = new UVModule();

      albedo = new AlbedoModule();
      alpha = null;
      fading = null;

      normalMap = new NormalMapModule();
      roughness = new RoughnessModule();
      metallic = new MetallicModule();
      specular = new SpecularModule();
      specular.domainMode = TextureModule.DomainMode.Value;
      occlusion = new OcclusionModule();
      
      emission = null;
      backlight = null;
      subsurfaceScattering = null;
    }

    public void PBR_Emissive_Starter()
    {
      transparency = new TransparencyModule();
      shading = new ShadingModule();
      stencil = null;

      geometry = new GeometryModule();

      uv = new UVModule();

      albedo = new AlbedoModule();
      alpha = null;
      fading = null;

      normalMap = new NormalMapModule();
      roughness = new RoughnessModule();
      metallic = new MetallicModule();
      specular = new SpecularModule();
      specular.domainMode = TextureModule.DomainMode.Value;
      occlusion = new OcclusionModule();
      
      emission = new EmissionModule();

      backlight = null;
      subsurfaceScattering = null;
    }

    public void PBR_Alpha_Starter()
    {
      transparency = new TransparencyModule();
      transparency.transparency = BaseMaterial3D.TransparencyEnum.Alpha;

      shading = new ShadingModule();
      stencil = null;

      geometry = new GeometryModule();

      uv = new UVModule();

      albedo = new AlbedoModule();
      alpha = new AlphaModule();
      fading = null;

      normalMap = new NormalMapModule();
      roughness = new RoughnessModule();
      metallic = new MetallicModule();
      specular = new SpecularModule();
      specular.domainMode = TextureModule.DomainMode.Value;
      occlusion = new OcclusionModule();

      emission = null;
      backlight = null;
      subsurfaceScattering = null;
    }

    public void Unshaded_Starter()
    {
      transparency = new TransparencyModule();
      transparency.transparency = BaseMaterial3D.TransparencyEnum.Alpha;

      shading = new ShadingModule();
      shading.shadingMode = BaseMaterial3D.ShadingModeEnum.Unshaded;
      stencil = null;

      geometry = new GeometryModule();

      uv = new UVModule();

      albedo = new AlbedoModule();
      alpha = new AlphaModule();
      fading = null;

      normalMap = null;
      roughness = null;
      metallic = null;
      specular = null;

      occlusion = null;
      emission = null;
      backlight = null;
      subsurfaceScattering = null;
    }

  }
}