using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{   
  public enum StencilWriteMode
  {
    Write_Depth_Success,
    Write_Depth_Fail,
    Write_Always
  }

  public enum StencilReadMode
  {
    Less,
    Equal,
    LessOrEqual,
    Greater,
    NotEqual,
    GreaterOrEqual
  }


  public enum StencilMode
  {
    Read,
    Write_Depth_Success,
    Write_Depth_Fail,
    Write_Always
  }

  public static class StencilModeUtility
  {
    public static string ConvertToShaderCode( StencilMode mode )
    {
      if ( StencilMode.Read == mode )
      {
        return "read";
      }

      if ( StencilMode.Write_Depth_Success == mode )
      {
        return "write";
      }

      if ( StencilMode.Write_Depth_Fail == mode )
      {
        return "write_depth_fail";
      }

      return "write, write_depth_fail";
    }

    public static string ConvertToShaderCode( BaseMaterial3D.StencilCompareEnum compareMode )
    {
      if ( BaseMaterial3D.StencilCompareEnum.Equal == compareMode )
      {
        return "compare_equal";
      }
      else if ( BaseMaterial3D.StencilCompareEnum.NotEqual == compareMode )
      {
        return "compare_not_equal";
      }
      
      else if ( BaseMaterial3D.StencilCompareEnum.Greater == compareMode )
      {
        return "compare_greater";
      }
      else if ( BaseMaterial3D.StencilCompareEnum.GreaterOrEqual == compareMode )
      {
        return "compare_greater_or_equal";
      }
      
      else if ( BaseMaterial3D.StencilCompareEnum.Less == compareMode )
      {
        return "compare_less";
      }
      else if ( BaseMaterial3D.StencilCompareEnum.LessOrEqual == compareMode )
      {
        return "compare_less_or_equal";
      }

      return "compare_always";
      
    }

    public static StencilMode ConvertWriteMode( StencilWriteMode writeMode )
    {
      if ( writeMode == StencilWriteMode.Write_Depth_Success )
      { return StencilMode.Write_Depth_Success; }

      if ( writeMode == StencilWriteMode.Write_Depth_Fail )
      { return StencilMode.Write_Depth_Fail; }

      return StencilMode.Write_Always;
    }

    public static BaseMaterial3D.StencilCompareEnum ConvertReadMode( StencilReadMode readMode )
    {
      if ( readMode == StencilReadMode.NotEqual )
      { return BaseMaterial3D.StencilCompareEnum.NotEqual; }


      if ( readMode == StencilReadMode.Less )
      { return BaseMaterial3D.StencilCompareEnum.Less; }      

      if ( readMode == StencilReadMode.LessOrEqual )
      { return BaseMaterial3D.StencilCompareEnum.LessOrEqual; }


      if ( readMode == StencilReadMode.Greater )
      { return BaseMaterial3D.StencilCompareEnum.Greater; }      

      if ( readMode == StencilReadMode.GreaterOrEqual )
      { return BaseMaterial3D.StencilCompareEnum.GreaterOrEqual; }


      return BaseMaterial3D.StencilCompareEnum.Equal;
    }
  }
  
}