using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  
  [Tool]
  [GlobalClass]
  public abstract partial class StencilModule:ShaderGenerationModule
  { 
    public abstract StencilMode GetStencilMode();

    public abstract BaseMaterial3D.StencilCompareEnum GetStencilCompare();

    public abstract int GetStencilReference();

    public string ToShaderCode()
    {
      var mode = StencilModeUtility.ConvertToShaderCode( GetStencilMode() );
      var compare = StencilModeUtility.ConvertToShaderCode( GetStencilCompare() ); 
      var reference = GetStencilReference();

      return $"stencil_mode {mode}, {compare}, {reference};";
    }

  }

}