using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  
  [Tool]
  [GlobalClass]
  public partial class StencilReadMask:StencilModule
  { 
    [Export]
    public StencilReadMode readMode = StencilReadMode.NotEqual;

    [Export]
    public StencilReference reference;    

    public override StencilMode GetStencilMode()
    { 
      return StencilMode.Read;
    }

    public override BaseMaterial3D.StencilCompareEnum GetStencilCompare()
    { 
      return StencilModeUtility.ConvertReadMode( readMode );
    }

    public override int GetStencilReference()
    { 
      return reference == null ? -1 : reference.GetReferenceIndex(); 
    }

  }
}