using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  
  [Tool]
  [GlobalClass]
  public partial class StencilWriteMask:StencilModule
  { 
    [Export]
    public StencilWriteMode mode = StencilWriteMode.Write_Depth_Success;

    [Export]
    public StencilReference reference;

    public override StencilMode GetStencilMode()
    { 
      return StencilModeUtility.ConvertWriteMode( mode );
    }

    public override BaseMaterial3D.StencilCompareEnum GetStencilCompare()
    { 
      return BaseMaterial3D.StencilCompareEnum.Always; 
    }

    public override int GetStencilReference()
    { 
      return reference == null ? -1 : reference.GetReferenceIndex(); 
    }

  }
}