using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class UVChannel:ShaderGenerationModule
  { 
    [Export]
    public string uvTarget = "UV";

    [Export]
    public UVSource uvSource = new MeshUVSource();

    [Export]
    public UVModifier modifier = new UVScaleOffset();


    public List<ShaderCode> GetShaderCode( ShaderGenerationContext context )
    {
      
      uvSource.uniformGroup = uniformGroup;
      modifier.uniformGroup = uniformGroup;
      
      var sourceCode = uvSource.GetUV( context, uvTarget, 0 );
      var modifierCode = modifier.ModifyUV( context, uvTarget );

      if ( sourceCode == null && modifierCode == null )
      {
        return null;
      }

      var list = new List<ShaderCode>();

      if ( sourceCode != null )
      {
        list.AddRange( sourceCode ); 
      }

      if ( modifierCode != null )
      {
        list.AddRange( modifierCode );
      }

      if ( ShaderPhase.Variables == context.phase && ! ( uvTarget == "UV" || uvTarget == "UV2" ) )
      {
        list.Add( ToCode( VaryingVec2( uvTarget ) + "\n" ) );
      }

      return list;      
    }
  } 
}