using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class UVModule:ShaderGenerationModule
  { 
    // [Export]
    // public UVScaleOffset uvScaleOffset = new UVScaleOffset();

    // [Export]
    // public UVModifier[] modifiers = [];

    [Export]
    public UVChannel[] channels = [ ];

    public override List<ShaderVariant> GetVariants( ShaderGenerationContext context )
    {
      var list = new List<ShaderCode>();

      channels.ForEach(
        ( c )=>
        {
          c.uniformGroup = "UVChannels";
          var code = c.GetShaderCode( context );

          if ( code == null )
          {
            return;
          }

          list.AddRange( code );
        }
      );

      list.ForEach( sc => sc.sortableCode = false );
      // var list = new List<ShaderVariant>();

      // var allModifiers = Lists.From( modifiers ).FilterNulls();

      // if ( uvScaleOffset != null )
      // {
      //   allModifiers.Insert( 0, uvScaleOffset );
      // }

      // allModifiers.ForEach(
      //   ( m )=>
      //   {
      //     var variants = m.GetVariants( context );
          
      //     if ( variants == null )
      //     {
      //       return;
      //     }

      //     list = ShaderVariant.CombineVariants( list, variants );
      //   }
      // );

      return ToVariants( list );
    }
  }
}