using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class MeshUVSource:UVSource
  { 
    public enum MeshUV
    {
      UV, 
      UV2, 
      CUSTOM0_XY, 
      CUSTOM0_YW,
      CUSTOM1_XY, 
      CUSTOM1_YW,
      CUSTOM2_XY, 
      CUSTOM2_YW,
      CUSTOM3_XY, 
      CUSTOM3_YW,
      COLOR_XY,
      COLOR_ZW
    }

    [Export]
    public MeshUV meshUV;

    public override List<ShaderCode> GetUV( ShaderGenerationContext context, string target, int offsetIndex )
    { 
      if ( ShaderPhase.Vertex != context.phase )
      {
        return null;
      }

      var meshUVstring = meshUV + "";

      if ( meshUVstring.Length > 3 && meshUVstring[ meshUVstring.Length - 3 ] == '_' )
      {
        var member = "." + meshUVstring.Substring( meshUVstring.Length - 2 );
        meshUVstring = meshUVstring.Substring( 0, meshUVstring.Length - 3 ) + member;
      }

      return ShaderGenerationModule.ToUnsortableCode( $"{target} = {meshUVstring};" );
    }
  }
}