using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class MeshAttributVarying: SpatialVaryingSource
  {  
    public enum MeshAttribute
    {
      COLOR,
      CUSTOM0,
      CUSTOM1,
      CUSTOM2,
      CUSTOM3,
      INSTANCE_CUSTOM
    }

    [Export]
    public MeshAttribute meshAttribute;

    public override List<ShaderCode> GetVaryingSource( ShaderGenerationContext context, string varyingName )
    {
      if ( ! context.isVertexPhase )
      {
        return null;  
      }

      return ToCode( $"{varyingName} = {meshAttribute + ""};\n");
    }
    
  }
}