using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class SpatialVarying:ShaderGenerationModule
  { 

    [Export]
    public SpatialVaryingVariable[] variables = [];

    public override List<ShaderVariant> GetVariants( ShaderGenerationContext context )
    {
      var list = new List<ShaderVariant>();
      variables.ForEach(
        ( v )=>
        {
          var vCode = v.GetVariants( context );

          if ( vCode == null )
          {
            return;
          }
          
          list = ShaderVariant.CombineVariants( list, vCode );
          
        }
      );

      return list;

    } 

    

  }
}