using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class SpatialVaryingVariable:ShaderGenerationModule
  { 
    [Export]
    public string variableName;

    [Export]
    public SpatialVaryingSource variableSource;

    public override List<ShaderVariant> GetVariants( ShaderGenerationContext context )
    {
      var list = new List<ShaderCode>();

      if ( context.isVariablesPhase )
      {
        list.Add( ToCode( $"varying vec4 {variableName};" ) );
      }
      else if ( context.isVertexPhase )
      {
        list.Add( variableSource.GetVaryingSource( context, variableName ) );
      }
      

      return ToVariants( list );
    }
  }
}