using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  public partial class CustomMaterial:ShaderMaterial
  {
    public void CopyUniformsFrom( ShaderMaterial material )
    {
      var uniforms = Shaders.GetUniformNames( material.Shader );

      uniforms.ForEach( 
        u => 
        {
          SetShaderParameter( u, material.GetShaderParameter( u ) );
        }
      );
    } 

    public static T CreateFrom<T>( ShaderMaterial m ) where T:CustomMaterial, new()
    {
      var t = new T();
      t.CopyUniformsFrom( m );

      return t;
    }

    public static CachedResource<T> Cached<T>( string path ) where T:CustomMaterial, new()
    {
      var cachedResource = new CachedResource<T>( path, 
        ( r ) =>
        { 
          return CreateFrom<T>( r as ShaderMaterial ); 
        }
      );

      return cachedResource;
    }
  }
}