using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  public class CustomMaterialProperty<[MustBeVariant] T>
  { 
    public CustomMaterialProperty( CustomMaterial m, ShaderPropertyName n )
    {
      _material = m;
      _name = n;
    }

    protected CustomMaterial _material;
    ShaderPropertyName _name;

    public S GetPropertyName<S>() where S:ShaderPropertyName
    {
      return _name as S;
    }

    public string propertyName => _name.propertyName;

    public T Get()
    {
      return _name._Get<T>( _material, default( T ) );
    }

    public void Set( T value )
    {
      _name._Set<T>( _material, value );
    }

    T _cachedValue = default( T );

    public void SetCached( T value )
    {
      Set( value );
      _cachedValue = value;
    }

    public T GetCached()
    {
      return _cachedValue;
    }

    public void AssignFor( CustomMaterial material, T value )
    {
      _name._Set<T>( material, value );
    }

    public void AssignFor( List<CustomMaterial> materials, T value )
    {
      materials.ForEach( m => AssignFor( m, value ) );
    }
        
  }
}