using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class MaterialDelta:Resource
  { 
    public List<ColorProperty> colorProperties = new List<ColorProperty>();
    public List<FloatProperty> floatProperties = new List<FloatProperty>();

    public override string ToString()
    {
      var sb = new StringBuilder();
      colorProperties.ForEach( c => sb.Append( c.propertyName.propertyName + ", " ) );
      floatProperties.ForEach( f => sb.Append( f.propertyName.propertyName + ", " ) );
      return sb.ToString();
    }

    public static MaterialDelta Create( Material a, Material b )
    {
      if ( ! Materials.HaveSameShaderType( a, b ) )
      {
        return null;
      }

      var delta = new MaterialDelta();

      var uniforms = Shaders.GetUniformMembers( a );

      uniforms.ForEach(
        ( u )=>
        {

          if ( Variant.Type.Color == u.type )
          {
            var colorA = u.Get<Color>( a );
            var colorB = u.Get<Color>( b );

            if ( colorA == colorB )
            {
              return;
            }

            // RJLog.Log( "Is Different", u.name, ":",  u.type, ">>", colorA, colorB );

            delta.colorProperties.Add( ColorProperty.Create( u.name, colorB ) );
          }

          if ( Variant.Type.Float == u.type )
          {
            var floatA = u.Get<float>( a );
            var floatB = u.Get<float>( b );

            if ( floatA == floatB )
            {
              return;
            }


            // RJLog.Log( "Is Different", u.name, ":",  u.type, ">>", floatA, floatB );

            delta.floatProperties.Add( FloatProperty.Create( u.name, floatB ) );
          }
        }
      );

      return delta;
    }
  }
}