using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
    [Tool]
  [GlobalClass]
  public partial class MaterialTransfer:Resource
  { 
    [Export]
    public SubMaterialTransfer[] transfers = new SubMaterialTransfer[ 0 ];

    public void Transfer( Material source, Material target )
    {
      Lists.From( transfers ).ForEach(
        ( t )=>
        {
          if ( ! t.MatchesMaterial( source ) )
          {
            RJLog.Log( t.info, "not matching:", source );
            return;
          }
          
          RJLog.Log( t.info, "from", source, "to", target );

          t.Transfer( source, target );

        }
      );
    }
  }
}

