using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class TextureChannelToVector4Transfer:CustomMaterialTransfer
  { 
    [Export]
    public TextureChannelPropertyName from; 

    [Export]
    public Vector4PropertyName to;

    public override void Transfer( Material a, Material b )
    {
      var v = from.Get( a );

      var v4 = Vector4.Zero;

      if ( BaseMaterial3D.TextureChannel.Alpha == v )
      {
        v4 = new Vector4( 0, 0, 0, 1 );
      }
      else if ( BaseMaterial3D.TextureChannel.Red == v )
      {
        v4 = new Vector4( 1, 0, 0, 0 );
      }
      else if ( BaseMaterial3D.TextureChannel.Green == v )
      {
        v4 = new Vector4( 0, 1, 0, 0 );
      }
      else if ( BaseMaterial3D.TextureChannel.Blue == v )
      {
        v4 = new Vector4( 0, 0, 1, 0 );
      }
      else if ( BaseMaterial3D.TextureChannel.Grayscale == v )
      {
        v4 = new Vector4( 1f/3f, 1f/3f, 1f/3f, 0 );
      }


      to.Set( b, v4 );

    }

  }
}

