using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class BoolPropertyName : ShaderPropertyName
  { 
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    {
      return RenderingServer.GlobalShaderParameterType.Bool;
    }

    public void Set( Material material, bool value )
    {
      _Set( material, value );
    }

    public bool Get( Material material )
    {
      return _Get( material, false );
    }

     public static BoolPropertyName Create( string name )
    {
      var p = new BoolPropertyName();
      p.propertyName = name;
      return p;
    }
  }
}