using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class ColorPropertyName : ShaderPropertyName
  { 
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    {
      return RenderingServer.GlobalShaderParameterType.Color;
    }

    public static readonly ColorPropertyName albedo = Create( "albedo" );
     
    public void Set( Material material, Color value )
    {
      _Set( material, value );
    }

    public Color Get( Material material )
    {
      return _Get( material, Colors.Black );
    }

    public static ColorPropertyName Create( string name )
    {
      var p = new ColorPropertyName();
      p.propertyName = name; 
      return p;
    }
  }
}