using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class IntPropertyName : ShaderPropertyName
  { 
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    {
      return RenderingServer.GlobalShaderParameterType.Int;
    }

    public void Set( Material material, int value )
    {
      _Set( material, value );
    }

    public int Get( Material material )
    {
      return _Get( material, 0 );
    }

    public static IntPropertyName Create( string name )
    {
      var p = new IntPropertyName();
      p.propertyName = name; 
      return p;
    }
  }
}