using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class ColorProperty : ShaderProperty
  { 
    [Export]
    public ColorPropertyName propertyName;

    [Export]
    public Color color;

    public override ShaderPropertyName GetPropertyName(){ return propertyName; }
    public override Variant GetValue(){ return color; }
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    { 
      return RenderingServer.GlobalShaderParameterType.Color;
    }

    public override void Apply( Material material )
    {
      propertyName.Set( material, color );
    }

    public void ReadFrom( Material material )
    {
      color = propertyName.Get( material );
    }

    public void ApplyLerped( Material material, Color from, float lerpState )
    {
      var lerpedColor = from.Lerp( color, lerpState );
      propertyName.Set( material, lerpedColor );
    }

    public static ColorProperty Create( string name, Color color )
    {
      var cp = new ColorProperty();
      cp.propertyName = ColorPropertyName.Create( name );
      cp.color = color;
      return cp;
    }
  }
}