using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class FloatProperty : ShaderProperty
  { 
    [Export]
    public FloatPropertyName propertyName;

    [Export]
    public float value;

    public override ShaderPropertyName GetPropertyName(){ return propertyName; }
    public override Variant GetValue(){ return value; }
    
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    { 
      return RenderingServer.GlobalShaderParameterType.Float;
    }

    public override void Apply( Material material )
    {
      propertyName.Set( material, value );
    }

    public void ReadFrom( Material material )
    {
      value = propertyName.Get( material );
    }

    public void ApplyLerped( Material material, float from, float lerpState )
    {
      var lerpedValue = Mathf.Lerp( from, value, lerpState );
      propertyName.Set( material, lerpedValue );
    }

    public static FloatProperty Create( string name, float value )
    {
      var fp = new FloatProperty();
      fp.propertyName = FloatPropertyName.Create( name );
      fp.value = value;
      return fp;
    }
  }
}