using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class Sampler2DProperty : ShaderProperty
  { 
    [Export]
    public Sampler2DPropertyName propertyName;

    [Export]
    public Texture2D value;

    public override ShaderPropertyName GetPropertyName(){ return propertyName; }
    public override Variant GetValue(){ return value; }
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    { 
      return RenderingServer.GlobalShaderParameterType.Sampler2D;
    }

    public override void Apply( Material material )
    {
      propertyName.Set( material, value );
    }

    public void ReadFrom( Material material )
    {
      value = propertyName.Get( material );
    }

    public static Sampler2DProperty Create( string name, Texture2D value )
    {
      var sp = new Sampler2DProperty();
      sp.propertyName = Sampler2DPropertyName.Create( name );
      sp.value = value;
      return sp;
    }
  }
}