using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class SetGlobalVector3PropertyFromNode:Action
  { 
    [Export]
    public Node3D node3D;

    [Export]
    public bool global;

    [Export]
    public Vector3PropertyName name;

    [Export]
    public Smoothing smoothing;

    [Export]
    public TimeLine timeLine;
    
    [Export]
    public Node3D debug;

    protected override void _OnTrigger()
    {
      var rm = Unique<RenderingManager>.Get();
      var p = rm.GetShaderPropertyByName<Vector3Property>( name );

      if ( p == null )
      {
        return;
      }

      var tl = TimeLineManager.Ensure( timeLine );
      var position = Smoothing.Apply( smoothing, node3D.GetPosition( global ), tl.delta );

      if ( debug != null )
      {
        debug.GlobalPosition = position;
      }
      
      p.value = position;

    }


  }
}