using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public abstract partial class ShaderProperty : Resource
  { 
    public virtual void Apply( Material material )
    {}

    public void ApplyGlobal()
    {
      RenderingServer.GlobalShaderParameterSet( name, GetValue() );
    }

    public abstract RenderingServer.GlobalShaderParameterType GetParameterType();

    public void AddAsGlobalUniform()
    { 
      
      RenderingServer.GlobalShaderParameterAdd( name, GetParameterType(), GetValue() );
    }

    public string name => GetPropertyName()?.propertyName; 

    public abstract ShaderPropertyName GetPropertyName();

    public abstract Variant GetValue();

  }
}