using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class Vector2Property : ShaderProperty
  { 
    [Export]
    public Vector2PropertyName propertyName;
    [Export]
    public Vector2 value;

    public override ShaderPropertyName GetPropertyName(){ return propertyName; }
    public override Variant GetValue(){ return value; }
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    { 
      return RenderingServer.GlobalShaderParameterType.Vec2;
    }

    public override void Apply( Material material )
    {
      propertyName.Set( material, value );
    }

    public void ReadFrom( Material material )
    {
      value = propertyName.Get( material );
    }

    public void ApplyLerped( Material material, Vector2 from, float lerpState )
    {
      var lerpedValue = Math2D.Lerp( from, value, lerpState );
      propertyName.Set( material, lerpedValue );
    }

    public static Vector2Property Create( string name, Vector2 value )
    {
      var fp = new Vector2Property();
      fp.propertyName = Vector2PropertyName.Create( name );
      fp.value = value;
      return fp;
    }
  }
}