using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class Vector3Property : ShaderProperty
  { 
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    {
      return RenderingServer.GlobalShaderParameterType.Vec3;
    }
    
    [Export]
    public Vector3PropertyName propertyName;

    public override ShaderPropertyName GetPropertyName(){ return propertyName; }
    public override Variant GetValue(){ return value; }

    [Export]
    public Vector3 value;

    public override void Apply( Material material )
    {
      propertyName.Set( material, value );
    }

    public void ReadFrom( Material material )
    {
      value = propertyName.Get( material );
    }

    public void ApplyLerped( Material material, Vector3 from, float lerpState )
    {
      Vector3 lerpedValue = Math3D.Lerp( from, value, lerpState );
      propertyName.Set( material, lerpedValue );
    }

    public static Vector3Property Create( string name, Vector3 value )
    {
      var fp = new Vector3Property();
      fp.propertyName = Vector3PropertyName.Create( name );
      fp.value = value;
      return fp;
    }
  }
}