using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class Vector4Property : ShaderProperty
  { 
    [Export]
    public Vector4PropertyName propertyName;

    public override ShaderPropertyName GetPropertyName(){ return propertyName; }
    public override Variant GetValue(){ return value; }

    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    {
      return RenderingServer.GlobalShaderParameterType.Vec4;
    }


    [Export]
    public Vector4 value;

    public override void Apply( Material material )
    {
      propertyName.Set( material, value );
    }

    public void ReadFrom( Material material )
    {
      value = propertyName.Get( material );
    }

    public void ApplyLerped( Material material, Vector4 from, float lerpState )
    {
      var lerpedValue = from.Lerp( value, lerpState );
      propertyName.Set( material, lerpedValue );
    }

    public static Vector4Property Create( string name, Vector4 value )
    {
      var fp = new Vector4Property();
      fp.propertyName = Vector4PropertyName.Create( name );
      fp.value = value;
      return fp;
    }
  }
}