using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class Sampler2DPropertyName : ShaderPropertyName
  { 
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    {
      return RenderingServer.GlobalShaderParameterType.Sampler2D;
    }

    public static Sampler2DPropertyName albedoTexture = Create( "albedo_texture" );

    public void Set( Material material, Texture2D value )
    {
      _Set( material, value );
    }

    public Texture2D Get( Material material )
    {
      return _Get<Texture2D>( material, null );
    }

    public static Sampler2DPropertyName Create( string name )
    {
      var t = new Sampler2DPropertyName();
      t.propertyName = name;
      return t;
    }
  }
}