using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class Vector2IPropertyName : ShaderPropertyName
  { 
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    {
      return RenderingServer.GlobalShaderParameterType.Ivec2;
    }

    public void Set( Material material, Vector2I value )
    {
      _Set( material, value );
    }

    public Vector2I Get( Material material )
    {
      return _Get( material, Vector2I.Zero );
    }

    public static Vector2IPropertyName Create( string name )
    {
      var p = new Vector2IPropertyName();
      p.propertyName = name; 
      return p;
    }
  }
}