using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class Vector2PropertyName : ShaderPropertyName
  { 
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    {
      return RenderingServer.GlobalShaderParameterType.Vec2;
    }

    public string propertyNameX => propertyName + ".x";
    public string propertyNameY => propertyName + ".y";

    public void Set( Material material, Vector2 value )
    {
      _Set( material, value );
    }

    public Vector2 Get( Material material )
    {
      return _Get( material, Vector2.Zero );
    }

    public static Vector2PropertyName Create( string name )
    {
      var p = new Vector2PropertyName();
      p.propertyName = name; 
      return p;
    }
  }
}