using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class Vector3PropertyName : ShaderPropertyName
  { 
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    {
      return RenderingServer.GlobalShaderParameterType.Vec3;
    }

    public string propertyNameX => propertyName + ".x";
    public string propertyNameY => propertyName + ".y";
    public string propertyNameZ => propertyName + ".z";

    public void Set( Material material, Vector3 value )
    {
      _Set( material, value );
    }

    public Vector3 Get( Material material )
    {
      return _Get( material, Vector3.Zero );
    }

    public static Vector3PropertyName Create( string name )
    {
      var p = new Vector3PropertyName();
      p.propertyName = name; 
      return p;
    }
  }
}