using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class Vector4PropertyName : ShaderPropertyName
  {   
    public override RenderingServer.GlobalShaderParameterType GetParameterType()
    {
      return RenderingServer.GlobalShaderParameterType.Vec4;
    }

    public string propertyNameX => propertyName + ".x";
    public string propertyNameY => propertyName + ".y";
    public string propertyNameZ => propertyName + ".z";
    public string propertyNameW => propertyName + ".w";

    public void Set( Material material, Vector4 value )
    {
      _Set( material, value );
    }

    public Vector4 Get( Material material )
    {
      return _Get( material, Vector4.Zero );
    }

    public static Vector4PropertyName Create( string name )
    {
      var p = new Vector4PropertyName();
      p.propertyName = name; 
      return p;
    }
  }

}