using System.Collections;
using System.Collections.Generic;
using System;
using System.Reflection;
using System.Text.RegularExpressions;

namespace Rokojori
{

  public class MultiValueSorter<T>
  {
    List<ValueSorter<T>> valueSorters = new List<ValueSorter<T>>();

    public void AddValueSorter( Func<T,float> getFloatValue, bool reverse = false )
    {
      var valueSorter = ValueSorter<T>.Create( getFloatValue, reverse );
      valueSorters.Add( valueSorter );
    }

    public void Sort( List<T> data )
    {
      valueSorters.ForEach( v => v.ClearCache() );
      data.Sort( ( a, b ) => Compare( a, b ) );
    } 

    public void Sort( int index, int count, List<T> data )
    {
      valueSorters.ForEach( v => v.ClearCache() );
      data.Sort( index, count, Comparer<T>.Create( ( a, b ) => Compare( a, b ) ) );
    } 

    public int Compare( T a, T b )
    {
      for ( int i = 0; i < valueSorters.Count; i++ )
      {
        var valueProvider = valueSorters[ 0 ];

        var result = valueProvider.Compare( a, b );

        if ( result != 0 )
        {
          return result;
        }
      }

      return 0;
    }    

    public static MultiValueSorter<T> Create( params Func<T,float>[] valueSorterFunctions )
    {
      var multiSorter = new MultiValueSorter<T>();

      for ( int i = 0; i < valueSorterFunctions.Length; i++ )
      {
        multiSorter.AddValueSorter( valueSorterFunctions[ i ] );
      }

      return multiSorter;
    }


    public static void SortBy( List<T> data, params Func<T,float>[] valueSorterFunctions )
    {
      Create( valueSorterFunctions ).Sort( data );
    } 
  }
}