
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  public class Map<K,V> : Dictionary<K,V>
  { 
    public void ForEach( Action<K,V> callback )
    {
      foreach ( var kv in this )
      {
        callback( kv.Key, kv.Value );
      }
    }

    public K FindKey( Func<K, bool> evaluater )
    {
      foreach ( var kv in this )
      {
        if ( evaluater( kv.Key ) )
        {
          return kv.Key;
        }
      }

      return default( K );

    }

  }

  public class StringMap : Map<string,string>
  {
    public string ReplaceAll( string source )
    {
      return RegexUtility.ReplaceMultiple( source, this );
    }
  }
}