
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  public class MapList<K,V>:Map<K,List<V>>
  {
    
    public void Add( K key, V value )
    {
      if ( ! ContainsKey( key ) )
      {
        this[ key ] = new List<V>();
      }

      this[ key ].Add( value );
    }

    public void AddIfNotPresent( K key, V value )
    {
      if ( ContainsKey( key ) && this[ key ].Contains( value ) )
      {
        return;
      }

      Add( key, value );
    }

    public void Remove( K key, V value )
    {
      if ( ! ContainsKey( key ) )
      {
        return;
      }

      var list = this[ key ];

      list.Remove( value );

      if ( list.Count == 0 )
      {
        Remove( key );
      }
    }
  }
}