
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  public class MultiMap<K1,K2,V>:Map<K1,Map<K2,V>>
  { 
    public bool Has( K1 key1, K2 key2 )
    {
      if ( ! ContainsKey( key1 ) )
      {
        return false;
      }

      return this[ key1 ].ContainsKey( key2 );
    }

    public V Get( K1 key1, K2 key2 )
    {
      if ( key1 == null || key2 == null )
      {
        return default(V);
      }

      if ( ! ContainsKey( key1 ) )
      {
        return default(V);
      }

      if ( ! this[ key1 ].ContainsKey( key2 ) )
      {
        return default(V);
      }

      return this[ key1 ][ key2 ];
    }

    public void Set( K1 key, K2 key2, V value )
    {
      if ( ! ContainsKey( key ) )
      {
        this[ key ] = new Map<K2,V>();
      }

      this[ key ][ key2 ]= value;
    }

    public void Remove( K1 key, K2 key2, V value )
    {
      if ( ! ContainsKey( key ) )
      {
        return;
      }

      var dictionary = this[ key ];

      if ( ! dictionary.ContainsKey( key2 ) )
      {
        return;
      }

      dictionary.Remove( key2 );

      if ( dictionary.Count == 0 )
      {
        Remove( key );
      }
    }
  }
}