
using System.Collections.Generic;

namespace Rokojori
{  
  public class QueueList<T>:List<T>
  {
    List<T> _queuedInsertions = new List<T>();
    List<T> _queuedRemovals   = new List<T>();

    public void QueueInsert( T t )
    {
      _queuedInsertions.Add( t );
    }

    public void QueueRemoval( T t )
    {
      _queuedRemovals.Add( t );
    }

    public void IterateAndResolve( System.Action<T> callback )
    {
      ResolveRemovalsQueue();
      ResolveInsertionQueue();

      this.ForEach( t => callback( t ) );

      ResolveRemovalsQueue();
    } 

    protected void ResolveInsertionQueue()
    {
      if ( _queuedInsertions.Count == 0 )
      {
        return;
      }

      AddRange( _queuedInsertions );
      _queuedInsertions.Clear();
    }

    protected void ResolveRemovalsQueue()
    {
      if ( _queuedRemovals.Count == 0 )
      {
        return;
      }
      
      Lists.RemoveRange( this, _queuedRemovals );
      _queuedRemovals.Clear();
    }

  }
}